	clear all
	close all
	clc
	% Lattice Wave Digital Filter 12.4 CONSTANT-RP
	% Requirements for the digital lowpass filter
	wcT = 0.24*pi;	wsT = 0.40*pi;	Amax = 0.2;	Amin = 45; T = 1;
	wc = (2/T)*tan(wcT/2); ws = (2/T)*tan(wsT/2); 
	wsx = ws*0.97; Aminx = Amin*1.03;
	N = CA_CONST_R_ORDER_S(wc, wsx, Aminx)
	N = 7
	[Ga,Za,R_ZEROS,Pa,wsnew] = CA_CONST_R_POLES_S(wc,wsx,Aminx,N);
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, 1);   		
	[S1num, S1den, S2num, S2den] = SORT_LATTICE_POLES_LP_Z(P);  
	[a_odd, a_even] = CASCADE_RICHARDS_SECTIONS(S1den, S2den)
	wTpassb = linspace(0,wcT,100); 	wTstopb = linspace(wsT,pi,100); 
	load mincost;	% Computes the required number of shift-and-adds for an integer
	Wc = 7; WX = 2^Wc; TempCost = 100;
	a_odd = round(a_odd*WX);  %	a_odd(3) = mrpT2 < -- > (-rpT)^2
	a_even = round(a_even*WX); % a_even(2) = mrpT2; a_even(4) = mrpT2;
	N0 = 20; N1= 20;  Fail = 1; disp(['Searching, Please wait'])
 	for mrpT2 = 66:66	% for the constant coefficients
		C_odd(3) = mrpT2; C_even(2) = mrpT2; C_even(4) = mrpT2;
		for k0 = -N0:N1		 
			C_odd(1) = a_odd(1)+k0;
			for k1 = -N0:N1		 
				C_odd(2) = a_odd(2)+k1;
				Cost_odd = sum(mincost(abs(C_odd)));
	 		 	for k2 = -N0:N1	 
					C_even(1) = a_even(1)+k2;
					for k3 = -N0:N1	 
						C_even(3) = a_even(3)+k3;
						Cost = Cost_odd+sum(mincost(abs(C_even)));
						if Cost < TempCost	
							[S1, S2] = LATTICE_RICHARDS_H(C_odd/WX, C_even/WX, wTstopb);
							Att = MAG_2_ATT(0.5*(S2-S1));	
							if min(Att) >= Amin
								[S1, S2] = LATTICE_RICHARDS_H(C_odd/WX, C_even/WX, wTpassb);
								Att = MAG_2_ATT(0.5*(S2-S1));
								if min(Att) <= Amax
									a_odd0 = C_odd;
									a_even0 = C_even;
									TempCost = Cost
									Fail = 0; 
								end
							end
						end
					end
				end
			end
		end
	end
 
	if Fail == 1
		disp(['Failed']), break
	end
	figure(2)
	subplot('position', [0.1 0.4 0.88 0.5]);
	wT = linspace(0, pi, 1000); 
	a_odd = a_odd0
	a_even = a_even0	
	TempCost
	WX
	
	[S1, S2] = LATTICE_RICHARDS_H(a_odd/WX,a_even/WX, wT);
	Att = MAG_2_ATT(0.5*(S2 - S1));
	PLOT_ATT_Z(wT, Att, pi, 70)		
	figure(3)
	PLOT_PZ_Z(Z, P)
		
